<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class WhatsappButton extends Module
{
    public function __construct()
    {
        $this->name = 'whatsappbutton';
        $this->tab = 'front_office_features';
        $this->version = '1.1.2';
        $this->author = 'El Estudio de Andrés';
        $this->need_instance = 0;

        parent::__construct();

        $this->displayName = $this->l('Botón WhatsApp');
        $this->description = $this->l('Añade un sencillo botón flotante de WhatsApp en tu tienda.');
        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('displayBeforeBodyClosingTag')
            && Configuration::updateValue('WHATSAPP_NUMBER', '34600111222')
            && Configuration::updateValue('WHATSAPP_ENABLED', 1);
    }

    public function uninstall()
    {
        Configuration::deleteByName('WHATSAPP_NUMBER');
        Configuration::deleteByName('WHATSAPP_ENABLED');
        return parent::uninstall();
    }

    public function getContent()
    {
        if (Tools::isSubmit('submit_whatsappbutton')) {
            $number = Tools::getValue('WHATSAPP_NUMBER');
            $enabled = (int)Tools::getValue('WHATSAPP_ENABLED');

            if (!preg_match('/^\d+$/', $number)) {
                $output = $this->displayError($this->l('Número inválido, solo dígitos.'));
            } else {
                Configuration::updateValue('WHATSAPP_NUMBER', $number);
                Configuration::updateValue('WHATSAPP_ENABLED', $enabled);
                $output = $this->displayConfirmation($this->l('Configuración actualizada.'));
            }

            return $output . $this->renderForm();
        }

        return $this->renderForm();
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Configuración'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enable WhatsApp?'),
                        'name' => 'WHATSAPP_ENABLED',
                        'is_bool' => true,
                        'desc' => $this->l('Activar o desactivar el botón de WhatsApp'),
                        'values' => array(
                            array(
                                'id' => 'WHATSAPP_ENABLED_ON',
                                'value' => 1,
                                'label' => $this->l('Sí')
                            ),
                            array(
                                'id' => 'WHATSAPP_ENABLED_OFF',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Número de WhatsApp'),
                        'name' => 'WHATSAPP_NUMBER',
                        'size' => 20,
                        'required' => true,
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_note',
                        'html_content' => '<p style="margin-top:-10px;color:#777;font-size:13px;">
                            Introduce solo dígitos, incluyendo el código de país. Ejemplo: <strong>34600111222</strong>
                        </p>',
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Guardar'),
                    'class' => 'btn btn-default pull-right',
                ),
            ),
        );

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ?? 0;
        $helper->title = $this->displayName;
        $helper->submit_action = 'submit_whatsappbutton';
        $helper->fields_value['WHATSAPP_NUMBER'] = Configuration::get('WHATSAPP_NUMBER');
        $helper->fields_value['WHATSAPP_ENABLED'] = Configuration::get('WHATSAPP_ENABLED');

        return $helper->generateForm(array($fields_form)) . $this->getPromoHtml();
    }

    private function getPromoHtml()
    {
        return '<div style="margin-top:30px;padding:15px;border:1px solid #d3d3d3;background:#f8f8f8;border-radius:5px;">
            <h3 style="margin-top:0;color:#1a7aa3;">¿Te gustaría más módulos personalizados?</h3>
            <p>Desarrollamos módulos a medida para tu tienda PrestaShop.</p>
            <p>Contacta con <strong>El Estudio de Andrés</strong> en <a href="mailto:info@elestudiodeandres.com">info@elestudiodeandres.com</a> o visita <a href="https://elestudiodeandres.com" target="_blank">elestudiodeandres.com</a></p>
        </div>';
    }

    public function hookDisplayBeforeBodyClosingTag()
    {
        if (!Configuration::get('WHATSAPP_ENABLED')) {
            return '';
        }

        $whatsapp_number = Configuration::get('WHATSAPP_NUMBER');
        if (empty($whatsapp_number)) {
            return '';
        }

        $this->context->smarty->assign([
            'whatsapp_number' => $whatsapp_number,
            'module_dir' => $this->_path,
        ]);

        return $this->display(__FILE__, 'views/templates/hook/displaybeforebodyclosingtag.tpl');
    }
}
